#define _CRT_SECURE_NO_WARNINGS
#define _USE_MATH_DEFINES
#include <iostream>
#include <vector>
#include <string>
#include <algorithm>
#include <cmath>
#include <limits.h>
#include <queue>
#include <stack>
#include <deque>
#include <set>
#include <map>
#include <hash_set>
#include <hash_map>
#include <utility>
#include <stdio.h>
#include <time.h>
using namespace std;

#define EPS 1E-7
#define MOD 1000000007
#define mp make_pair

vector<vector<int>>g;

long long gcd(long long a, long long b){
	if(!b)return a;
	return gcd(b,a%b);
}

struct frac{
	long long up,down;
	frac(){};
	frac(long long a, long long b){
		up=a,down=b;
	}
	void reduce(){
		long long t = gcd(abs(up),abs(down));
		up/=t;
		down/=t;
		if(up<0){
			up=-up;
			down=-down;
		}
	}
};

frac sum(frac a, frac b){
	frac res;
	res.up = a.up*b.down + a.down*b.up;
	res.down = a.down*b.down;
	res.reduce();
	return res;
}


int main(){
	freopen("input.txt", "r", stdin); freopen("output.txt", "w", stdout);

	string str;
	while(cin>>str, str!="#"){
		vector<int>vec;

		reverse(str.begin(),str.end());
		//north - htron
		//west - tsew
		for(int i=0; i<str.size(); ++i){
			if(str[i]=='h'){
				vec.push_back(0);
				i+=4;
			}
			else{
				vec.push_back(1);
				i+=3;
			}
		}

		//0 - north
		//1 - west

		frac res;

		if(vec[0]==0){
			res.up = 0;
			res.down = 1;
		}
		else{
			res.up = 90;
			res.down = 1;
		}
		for(int i=1; i<vec.size(); ++i){
			frac temp;
			temp.up = 90;
			temp.down = ((long long)(1)<<i);
			if(!vec[i])temp.up*=-1;
			res = sum(res,temp);
		}

		if(res.down == 1){
			cout << res.up << endl;
		}
		else{
			cout << res.up << "/" << res.down << endl;
		}
	}
	return 0;
}